#include "USB_PD.H"

bit Support_5V_Flag;
bit Support_9V_Flag;
bit Support_12V_Flag;
bit Support_15V_Flag;
bit Support_20V_Flag;
bit Flag_select_mode;
bit sel_keystate, set_keystate;
U8 Select_mode = 0;
U8 Set_volt = 0;
U8 PDO_9V_index;
U8 PDO_12V_index;
U8 PDO_15V_index;
U8 PDO_20V_index;
U8  retry_counter = 0;
U8 Vbus_onDebounce, Vbus_offDebounce;
DWTYPE PD_Source_PDO[7] = 0;   //Source support Power Data Object
extern U8 PD_TX_length;
U8 USB_Port_Status = 0 ;
U8 PD_Communication_Status;
U8 PD_RX_length;
U8 PD_TXdata[34];           //max 2byte header + 28byte data + 4byte crc32
U8 PD_TX_Field;
U8 PD_TX_Count;
UU32 CRC32_result;
bit Flag_1ms, Flag_10ms, Flag_500ms;
U8 Timer_10ms;
U8 Timer_500ms;
U16 Timer_ms = 0;
U8 CCDebounce;
U8 SelKeyDebounce;
U8 SetKeyDebounce;
U8 Timeout_select;
U8 DetectDevice;
U8 code GoodCRC_0 [] = { 0x81, 0x00, 0xF5, 0xBB, 0x41, 0x63};   //Sink respond Goodcrc & crc32 MessageID0
U8 code GoodCRC_1 [] = { 0x81, 0x02, 0xD9, 0xDA, 0x4F, 0x8D};   //Sink respond Goodcrc & crc32 MessageID1
U8 code GoodCRC_2 [] = { 0x81, 0x04, 0xEC, 0x7F, 0x2C, 0x64};   //Sink respond Goodcrc & crc32 MessageID2
U8 code GoodCRC_3 [] = { 0x81, 0x06, 0xC0, 0x1E, 0x22, 0x8A};   //Sink respond Goodcrc & crc32 MessageID3
U8 code GoodCRC_4 [] = { 0x81, 0x08, 0xC7, 0x33, 0x9A, 0x6D};   //Sink respond Goodcrc & crc32 MessageID4
U8 code GoodCRC_5 [] = { 0x81, 0x0A, 0xEB, 0x52, 0x94, 0x83};   //Sink respond Goodcrc & crc32 MessageID5
U8 code GoodCRC_6 [] = { 0x81, 0x0C, 0xDE, 0xF7, 0xF7, 0x6A};   //Sink respond Goodcrc & crc32 MessageID6
U8 code GoodCRC_7 [] = { 0x81, 0x0E, 0xF2, 0x96, 0xF9, 0x84};   //Sink respond Goodcrc & crc32 MessageID7
xdata U8 PD_RXdata[34];
U8 PD_RX_SOP[4];
U8 PD_RX_Field;
U8 Header_Highbyte, Header_Lowbyte;




void Initial_CRC32();

/**
 *******************************************************************************
 * @brief         Timer0 interrupt routine
 * @param[in]     none
 * @return        none
 *******************************************************************************
 */
void Timer0_ISR(void) interrupt 1
{
    _push_(SFRPI);
    Flag_1ms = 1;
    Timer_ms++;
    Timer_10ms++;

    if ((pd_flags & PD_TX_RETRY) && (retry_counter < 2))
    {
        pd_transmit_packet();   //retry
        retry_counter++;
    }
    Run_USBPD();
    _pop_(SFRPI);
}


/**
 *******************************************************************************
 * @brief         UART1 interrupt routine
 * @param[in]     none
 * @return        none
 *******************************************************************************
 */
void UART1_ISR(void) interrupt 14
{
    U8 i = 0;
    _push_(SFRPI);
    SFRPI = 1;
    switch (PD_Communication_Status)
    {
        case IDLE:

            TI1 = RI1 = 0;

            if ((pd_flags & PD_FLAGS_NO_DETECT_SOP) == 0)
            {

                if (S1BUF == 0xFF || S1BUF == RX_EOP)
                    break;

                PD_RX_SOP [PD_RX_Field] = S1BUF;

                PD_RX_Field++;

                if (PD_RX_Field == 4)
                {

                    if (PD_RX_SOP [0] == 0x98)   //sync1
                        i++;

                    if (PD_RX_SOP [1] == 0x98)   //sync1
                        i++;

                    if (PD_RX_SOP [2] == 0x98)   //sync1
                        i++;

                    if (PD_RX_SOP [3] == 0x91)   //sync2
                        i++;

                    if (i >= 3)       //When the receiver finds three out of four K-codes in the correct place, it May interpret this as a Valid ordered set.
                    {

                        PD_RX_SOP [0] = PD_RX_SOP [1] = PD_RX_SOP [2] = PD_RX_SOP [3] = 0; //invalid or SOP'/SOP"
                        PD_RX_Field = 0;
                        PD_Communication_Status = RECEIVE;
                        __DRV_END45_mode(BMC_5bto4b);
                        SFRPI = 1;
                    }
                    else        //Hard reset
                    {
                        i = 0;

                        if (PD_RX_SOP [0] == 0x87)   //RST-1
                            i++;

                        if (PD_RX_SOP [1] == 0x87)    //RST-1
                            i++;

                        if (PD_RX_SOP [2] == 0x87)    //RST-1
                            i++;

                        if (PD_RX_SOP [3] == 0x99)     //RST-2
                            i++;

                        if (i >= 3)       //When the receiver finds three out of four K-codes in the correct place, it May interpret this as a Valid ordered set.
                        {
                            ISPCR |= SRST;   //MCU software reset
                        }
                    }
                }


                else if (PD_RX_Field >= 5)
                {
                    PD_RX_Field = 0;
                    pd_flags |= PD_FLAGS_NO_DETECT_SOP;
                }
            }
            else if ((S1BUF == RX_EOP)  || (S1BUF == 0xFF))       // EOP or EOF??
            {
                pd_flags &= ~PD_FLAGS_NO_DETECT_SOP;
                PD_RX_SOP [0] = PD_RX_SOP [1] = PD_RX_SOP [2] = PD_RX_SOP [3] = 0; //invalid or SOP'/SOP"
                PD_RX_Field = 0;
            }

            break;

        case RECEIVE:
            TI1 = RI1 = 0;
            if ((S1BUF & 0xE0) == 0)
            {
                //5b data 0~F

                EDC45 = S1BUF;              //decode 5b4b

                if ((PD_RX_Field & 0x01) != 0)      //high or low nibble?
                {
                    //high nibble

                    PD_RXdata[PD_RX_Field >> 1] = EDC45;    //1 byte, high/low nibble combine complete
                    BOREV = EDC45;                          // bit order flip for CRC32

                    switch (PD_RX_Field >> 1)
                    {
                        case 0:                         //Header b0~b7
                            Header_Lowbyte = EDC45;     //PD_RXdata[0]
                            CRC0DA = BOREV;             //CRC32 input
                            break;

                        case 1:                         //Header b8~b16
                            Header_Highbyte = EDC45;    //PD_RXdata[1]
                            CRC0DA = BOREV;
                            PD_RX_length = ((Header_Highbyte & 0x70) >> 2) + 2;     //PD_RX_length + 2byte header      //1=4byte data,0= control message,1~7 data message
                            break;

                        default:

                            if (PD_RX_length > 2 && PD_RX_length > PD_RX_Field >> 1)      //Data Field
                                CRC0DA = BOREV;

                            break;
                    }
                }
                PD_RX_Field++;
            }

            else if (S1BUF == RX_EOP)
            {
                AUXR1 &= ~(CRCDS1 | CRCDS0);        //CRC0 0 L
                BOREV = CRC0DA;
                CRC32_result.U8[0] = ~BOREV;
                AUXR1 |= CRCDS0;                    //CRC0 1 H
                BOREV = CRC0DA;
                CRC32_result.U8[1] = ~BOREV;
                AUXR1 |= CRCDS1;                    //CRC0 3
                BOREV = CRC0DA;
                CRC32_result.U8[3] = ~BOREV;
                AUXR1 &= ~CRCDS0;                   //CRC0 2
                BOREV = CRC0DA;
                CRC32_result.U8[2] = ~BOREV;

                if (CRC32_result.U8[3] == PD_RXdata[PD_RX_length] && CRC32_result.U8[2] == PD_RXdata[PD_RX_length + 1] &&
                        CRC32_result.U8[1] == PD_RXdata[PD_RX_length + 2]  && CRC32_result.U8[0] == PD_RXdata[PD_RX_length + 3])
                {
                    //CRC32 pass, respond Goodcrc

                    if ((PD_RX_length == 2) && ((U8) get_header_field(MSG_TYPE) == PD_GOODCRC))            //received goodcrc packet?
                    {
                        // GoodCRC
                        if (pd_messageid == (U8) get_header_field(MESSAGEID))
                        {

                            pd_messageid++;

                            if (pd_messageid >= 8)
                                pd_messageid = 0;

                            pd_flags &= ~PD_TX_RETRY;
                            Initial_CRC32();
                            retry_counter = 0;
                        }

                    }
                    else            //non GoodCRC
                    {
                        switch ((U8) get_header_field(MESSAGEID))        
                        {
                            case 0x00:           //Message ID 0
                                memmove(PD_TXdata, GoodCRC_0, 6);
                                break;

                            case 0x01:           //Message ID 1
                                memmove(PD_TXdata, GoodCRC_1, 6);
                                break;

                            case 0x02:           //Message ID 2
                                memmove(PD_TXdata, GoodCRC_2, 6);
                                break;

                            case 0x03:           //Message ID 3
                                memmove(PD_TXdata, GoodCRC_3, 6);
                                break;

                            case 0x04:           //Message ID 4
                                memmove(PD_TXdata, GoodCRC_4, 6);
                                break;

                            case 0x05:           //Message ID 5
                                memmove(PD_TXdata, GoodCRC_5, 6);
                                break;

                            case 0x06:           //Message ID 6
                                memmove(PD_TXdata, GoodCRC_6, 6);
                                break;

                            case 0x07:           //Message ID 7
                                memmove(PD_TXdata, GoodCRC_7, 6);
                                break;
                        }

                        __DRV_END45_mode(BMC_4bto5b);
                        SFRPI = 1;
                        PD_TX_length = 6;
                        PD_TX_Count = PD_TX_Field = 0;
                        PD_Communication_Status = TRANSFER;     //transfer goodcrc
                        retry_counter = 0;

                        pd_flags |= PD_FLAGS_RX_PACKET;
                        pd_flags &= ~PD_TX_RETRY;
                        PD_RX_Field = 0;
                        TI1 = 1;
                        TF0 = 1;
                        CC_bus_latch();
                    }

                } 

            }
            else if (S1BUF == 0xFF)   //EOF
            {

                PD_Communication_Status = IDLE;
                PD_RX_Field = 0;
                pd_flags &= ~PD_FLAGS_NO_DETECT_SOP;
            }

            break;

        case TRANSFER:
            TI1 = RI1 = 0;

            if (PD_TX_Field >= 12)              //header,data,crc32
            {
                if ((PD_TX_Field & 0x01) == 0)      //high or low nibble?
                {
                    EDC45 = PD_TXdata[PD_TX_Count];
                    S1BUF = EDC45;
                }
                else
                {
                    S1BUF = EDC45;
                    PD_TX_Count++;

                    if (PD_TX_Count >= PD_TX_length)
                    {
                        while (~TI1);         //wait last high nibble

                        TI1 = 0;
                        S1BUF = EOP;

                        while (~TI1);

                        TI1 = 0;
                        S1BUF = EOF1;

                        while (~TI1);           //end TX

                        TI1 = 0;
                        __DRV_END45_mode(BMC_5bto4b);
                        SFRPI = 1;
                        PD_Communication_Status = IDLE;
                        PD_RX_Field = 0;
                        pd_flags &= ~PD_FLAGS_NO_DETECT_SOP;
                        Initial_CRC32();
                        CC_bus_release();

                        if ((PD_TX_length != 6) && (get_header_field(MESSAGEID) != PD_GOODCRC))          //GoodCRC not retry
                        {
                            Clear_mTime;
                            pd_flags |= PD_TX_RETRY;
                        }

                        break;        //TX finish

                    }
                }
            }
            else if (PD_TX_Field < 12 &&  PD_TX_Field >= 8)     //SOP?
            {
                if ((pd_flags & PD_FLAGS_SEND_HARD_RESET) == 0)
                {
                    switch (PD_TX_Field)
                    {
                        case 8:
                        case 9:
                        case 10:
                            S1BUF = SYNC1;               //SOP SYNC1
                            break;

                        case 11:
                            S1BUF = SYNC2;               //SOP SYNC2
                            break;
                    }
                }
                else
                {
                    switch (PD_TX_Field)     //Hard reset
                    {
                        case 8:
                        case 9:
                        case 10:
                            S1BUF = RST1;               //SOP RST1
                            break;

                        case 11:

                            TI1 = 0;
                            S1BUF = RST2;           //SOP RST2
                            while (~TI1);
                            
                            TI1 = 0;
                            S1BUF = EOF1;

                            while (~TI1);           //end TX

                            TI1 = 0;
                            __DRV_END45_mode(BMC_5bto4b);
                            SFRPI = 1;
                            PD_Communication_Status = IDLE;
                            PD_RX_Field = 0;
                            pd_flags &= ~PD_FLAGS_NO_DETECT_SOP;
                            pd_flags &= ~PD_FLAGS_SEND_HARD_RESET;
                            Initial_CRC32();
                            CC_bus_release();
                            ISPCR |= SRST;   //MCU software reset
                            break;
                    }
                }
            }
            else
               S1BUF = 0xAA;                    //preamble

            PD_TX_Field++;

            break;

        default:
            TI1 = RI1 = 0;
            break;
    }

    _pop_(SFRPI);
}

/**
 *******************************************************************************
 * @brief       CC bus release(Idle or Receive)
 * @param[in]   none
 * @return      none
 *******************************************************************************
 */

void CC_bus_release()
{
    if ((USB_Port_Status == POWER5V_1P5A_CC1) || (USB_Port_Status == POWER5V_3A_CC1))
    {
        P11 = 0;
    }
    else
        P11 = 1;            //IO floating

    SFRPI = AUXR9_Page;
    AUXR9 &= ~(S1PS1 | S1PS0);    //RXD1 = P12
    SFRPI = 0;
    P1M0 &= 0xF5;      //P13/P11 opendrain output
    P13 = P11 =  1;    //IO floatng
    P07 = 1;           //P07 opendrain output high
}
/**
 *******************************************************************************
 * @brief       CC bus latch(Transfer)
 * @param[in]   none
 * @return      none
 *******************************************************************************
 */

void CC_bus_latch()
{
    if ((USB_Port_Status == POWER5V_1P5A_CC2) || (USB_Port_Status == POWER5V_3A_CC2))
    {
        SFRPI = AUXR9_Page;
        AUXR9 |= S1PS1;    //TXD1 = P11
    }

    SFRPI = 0;
    P1M0 |= 0x0A;      //P13/P11   pushpull output high
    P07 = 0;            //P07 opendrain output low
    P13 = P11 =  1;
}

/**
 *******************************************************************************
 * @brief       Initial CRC32
 * @param[in]   none
 * @return      none
 *******************************************************************************
 */

void Initial_CRC32()
{
    SFRPI = AUXR12_Page;
    AUXR12 |= CRCM0;        //CRC32
    AUXR12 &= ~(CRCDS2);    //BOREV Bit Order Reverse
    AUXR1 &= ~(CRCDS1 | CRCDS0);        //CRC0 0
    CRC0DA = 0xFF;
    AUXR1 |= CRCDS0;                    //CRC0 1
    CRC0DA = 0xFF;
    AUXR12 |= CRCDS2;                   //CRC0 3
    CRC0DA = 0xFF;
    AUXR1 &= ~CRCDS0;                   //CRC0 2
    CRC0DA = 0xFF;
    AUXR12 &= ~CRCDS2;
    AUXR1 |= CRCDS1 | CRCDS0;           //CRC0DI
    SFRPI = 0;
}
/**
 *******************************************************************************
 * @brief       Initial Timer0
 * @param[in]   none
 * @return      none
 *******************************************************************************
 */

void Initial_Timer()
{
    TMOD |= T0M1;          //TM0 8-bit timer

    AUXR2 |= T0X12;
    SFRPI = AUXR3_Page;    //AUXR3_Page = 0;
    AUXR3 |= T0XL;         //clock source SYSCLK/192

    TH0 = TL0 = 256 - 250; //48M/192/250 = 1K
    TR0 = 1;
    ET0 = 1;
    EA = 1;
}
/**
 *******************************************************************************
 * @brief       Initial System
 * @param[in]   none
 * @return      none
 *******************************************************************************
 */
void Initial_System()
{

    SEL_LED_5V = SEL_LED_9V = SEL_LED_12V = SEL_LED_15V = SEL_LED_20V = DRV_OFF;
    Support_5V_Flag = Support_9V_Flag = Support_12V_Flag = Support_15V_Flag = Support_20V_Flag = 0;
    PD_Communication_Status = IDLE;
    pd_flags &= ~PD_FLAGS_NO_DETECT_SOP;
    PD_RX_Field = 0;
    PD_RX_SOP [0] = PD_RX_SOP [1] = PD_RX_SOP [2] = PD_RX_SOP [3] = 0;
    __DRV_END45_mode(BMC_5bto4b);
    SFRPI = AUXR12_Page;
    AUXR12 |= GPLC0;  //SFR 0xA9 = EDC45 function;
    SFRPI = 0;
    set_keystate = sel_keystate = SET_KEY = SELECT_KEY = 1; //Button not pressed (defaulat)

}
/**
 *******************************************************************************
 * @brief       USB PD - main
 * @param[in]   none
 * @return      none
 *******************************************************************************
 */

void main()
{

    Select_PLL48MHz(); // PLL to 48MHz, CPU=24MHz
    Initial_GPIO();
    Initial_CRC32();
    Initial_UART1();
    Initial_ADC();
    Initial_Timer();
    Initial_System();
    while (1)
    {
        //main code (User define)
    }

}




/******************************************************************************
 @brief     Page P Read routine
 @param     Addr : specify address by Page-P write
 @return    return data from specify address
 *****************************************************************************/
U8 PageP_Read(U8 Addr)
{
    ISPCR = 0x80;
    IFADRH = 0x00;
    IFADRL = Addr;
    IFMT = 0x05;
    SCMD = 0x46;
    SCMD = 0xB9;

    return IFD;
}

/******************************************************************************
 @brief     Page P Write routine
 @param     Addr : specify address by Page-P write
 @param     dat : data 8 bit
 @return    none
 *****************************************************************************/
void PageP_Write(U8 Addr, U8 dat)
{
    ISPCR = 0x80;
    IFADRH = 0x00;
    IFADRL = Addr;
    IFD = dat;
    IFMT = 0x04;
    SCMD = 0x46;
    SCMD = 0xB9;

}
/******************************************************************************
 @brief     PLL to 48MHz
 @param     none
 @return    none
 *****************************************************************************/
void Select_PLL48MHz()
{
    U8 i;


    CKCON0 |= CCKS;             //CPU clock=System clock/2
    CKCON0 &= ~SCKS0;
    // PLL
    CKCON0 |= ENCKM;

    for (i = 0; i < 255; i++);   // delay

    CKCON0 &= ~(CKMIS1 | CKMIS0);
    CKCON0 |= (CKMIS0);

    PageP_Read(CKCON2_P);
    IFD &= ~(MCKS1_P | MCKS0_P);
    IFD |= (MCKS1_P | MCKS0_P);     // 48M Hz
    PageP_Write(CKCON2_P, IFD);
}

